﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace MVC_App.Models
{
	public enum Lieferzeitpunkte { Sofort, Heute, Am }
	public enum Zahlmodi { Haustür, Kreditkarte }
	public enum Getränke { Wasser, Apfelsaft, Kaffee }
	public enum Desserts { Tiramisu, PannaCotta, Eis }
	public enum PizzaGrößen { Mittel, Groß, Extragroß }

	public class OrderModel
	{
		public OrderModel(
			DateTime lieferzeitpunkt,
			ZahlungModel zahlung,
			GetränkModel getränk,
			PizzaModel pizza,
			DessertModel dessert)
		{
		}
	}

	public class GetränkSorteModel
	{
		public GetränkSorteModel(string name, int[] verfügbareVolumen)
		{
			Name = name;
			VerfügbareVolumen = verfügbareVolumen;
		}

		public string Name { get; private set; }
		public int[] VerfügbareVolumen { get; private set; }
	}

	public class GetränkModel
	{
		public GetränkModel(GetränkSorteModel sorte, string flaschengröße, bool gekühlt)
		{
			Sorte = sorte;
			Flaschengröße = flaschengröße;
			Gekühlt = gekühlt;
		}

		public GetränkSorteModel Sorte { get; private set; }
		public string Flaschengröße { get; private set; }
		public bool Gekühlt { get; private set; }
	}

	public class PizzaModel
	{
		public PizzaModel(string sorte, PizzaGrößen größe)
		{
			Größe = größe;
			Sorte = sorte;
		}

		public PizzaGrößen Größe { get; private set; }
		public string Sorte { get; private set; }
	}

	public class DessertModel
	{
		public DessertModel(Desserts art)
		{
			Art = art;
		}

		public Desserts Art { get; private set; }
	}


	public abstract class ZahlungModel { }

	public class HaustürZahlungModel : ZahlungModel { }

	public class KreditkarteZahlungModel : ZahlungModel
	{
		public string Name { get; set; }
		public string Nummer { get; set; }
		public DateTime GültigBis { get; set; }
		public string Bonität { get; set; }
	}
}
